<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\EolWipedCheckingInAssetsCount;
use Facades\App\Services\Dashboard\EOLWipedCheckingInAssetsCountService;

class EOLWipedCheckingInAssetsCountUpdate extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'EOLWipedCheckingInAssetsCount:update';
    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'This commad used for update count of assets which are eol wiped and checking in.';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        EolWipedCheckingInAssetsCount::truncate();
        EOLWipedCheckingInAssetsCountService::updateEOLWipedCheckingInAssetsCount();
        $this->info('EOL Wiped checking in assets count updated successfully.');
    }
}
