<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\User;

class DeleteDuplicateUsers extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'DeleteDuplicateUsers:delete';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Delete Duplicate Users';

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $uniqueAddresses = [];
        $duplicates = [];

        User::chunk(10000, function ($users) use (&$uniqueAddresses, &$duplicates) {
            foreach ($users as $user) {
                $address = sprintf("%s.%s.%s",
                    $user->email,
                    $user->first_name,
                    $user->last_name,
                    $user->employee_id
                );

                if (in_array($address, $uniqueAddresses)) {
                    // Address is a duplicate.
                    $duplicates[] = $user->id;
                } else {
                    $uniqueAddresses[] = $address;
                }
            }
        });

        foreach ($duplicates as $userId) {
            User::where('id', $userId)->doesntHave('assets')->delete();
        }

    }
}