<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Carbon\Carbon;
use App\Models\Asset;
use App\User;
use Illuminate\Support\Facades\Notification;
use App\Notifications\DamagedItems as Damaged;

class DamagedItems extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'DamagedItems:damageditems';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Damaged items admin notification';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
        $this->adminEmail = config('mail.adminAddress');
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        if (env('APP_ENV') == 'production') {
            $dateLastMonth = Carbon::now()->subDays(30);
            $assets = Asset::with('location', 'assetType', 'makeAndModel', 'technicalSpec', 'latestAssetHistory')->hasStatus('damaged')->whereHas('assetHistory', function ($query) use ($dateLastMonth) {
                $query->where('new_value', 'Damaged')
                    ->whereDate('created_at', '<=', $dateLastMonth);
            })->get();

            if ($assets) {
                Notification::route('mail', $this->adminEmail)->notify(new Damaged($assets));
            }
        }
    }
}
