<?php

namespace App\Console\Commands;

use App\Events\UpdateShipmentStatus;
use Illuminate\Console\Command;
use App\Models\Asset;
use App\Services\Integrations\Asn\CdwImportService;

use function Laravel\Prompts\confirm;

class CdwUploadAll extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'cdw:uploadall';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Upload all cdw files till date.';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct(protected CdwImportService $cdwService)
    {
        parent::__construct();
    }
    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $assetCount = 0;
        $k = 1;
        $path = storage_path('integration/cdw');
        if (!is_dir($path)) {
            $this->error('CDW directory not found');
            return false;
        }
        $patharray = getLatestFileNames($path);
        for ($i = 1; $i < sizeof($patharray) - 3; $i++) {
            $latestFile = $patharray[$i];
            if ($latestFile == "..") {
                continue;
            }
            if ($data = getItems($path . '/' . $latestFile)) {
                echo $latestFile . "\n";
                foreach ($data['csvData'] as $item) {
                    $cdwData = $this->cdwService->createAsnData($item, $k);

                    if ($validationErrors = $this->cdwService->checkIfAsnDataValid($cdwData, $k)) {
                        $errors[] = $validationErrors;
                        continue;
                    }
                    $asset = Asset::firstOrCreate($cdwData['assetData']);
                    $this->cdwService->createAssetHistory($asset);
                    $this->cdwService->updateTrackingNumber($item, 'Tracking Number', 'Serial Number');
                    $assetCount++;
                    $k++;
                }
            }
        }

        event(new UpdateShipmentStatus);

        return $this->info($assetCount . " assets added.");
    }
}
