<?php

namespace App\Console\Commands;

use App\Models\AssetHealthReportSchedule;
use Illuminate\Console\Command;
use Carbon\Carbon;
use App\Services\AssetsHealth\AssetsHealthReportSyncService;

class AssetHealthReport extends Command
{

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'assetHealthReport:run';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Generate Asset Health report and notify users';


    /**
     * Create a new command instance.
     *
     * @param AssetsHealthReportSyncService $syncService The service for syncing assets health reports.
     *
     * @return void
     */
    public function __construct(protected AssetsHealthReportSyncService $syncService)
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return void
     */
    public function handle()
    {
        $today = Carbon::now()->dayOfWeek;

        $reportSchedule = AssetHealthReportSchedule::first();

        if (!$reportSchedule) {
            $this->error('No scheduled day found in the database.');
            return;
        }

        if ($today == $reportSchedule->weekly_day) {
            $this->info('Asset Health Report Generating.');

            $this->syncService->sync();

            $this->syncService->createReportPdf();
        }
    }
}
