<?php

namespace App\Console\Commands;

use App\Models\ApiCredential;
use Illuminate\Console\Command;

class ApiCredentialsOnetimeRunnable extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'ApiCredentialsOnetimeRunnable:run';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Encrypt the API credentials in DB';


    /**
     * Execute the console command.
     *
     * @return void
     */
    public function handle()
    {
        $existingCredentials = ApiCredential::get();

        foreach ($existingCredentials as $credential) {
            $credential->update([
                'key' => $credential->key ? $credential->key : null,
                'password' => $credential->password ? $credential->password : null,
            ]);
        }

        $this->info('Done.');
    }
}
