<?php

namespace App\Console\Commands;

use Carbon\Carbon;
use Carbon\CarbonPeriod;
use Illuminate\Console\Command;
use App\Repositories\Security\Crowdstrike\CrowdstrikeReportRepository;
use App\Models\ActiveVulnerabilitiesPerWeek;

class ActiveVulnerabilitiesCountPerWeek extends Command
{

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'ActiveVulnerabilitiesCountPerWeek:update';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'This command update the vulnerabilities counts per week for the graph representation';


    /**
     * Constructor dor ActiveVulnerabilitiesCountPerWeek
     *
     * @param CrowdstrikeReportRepository $repository
     *
     * @return void
     */
    public function __construct(protected CrowdstrikeReportRepository $repository)
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return void
     */
    public function handle()
    {
        ActiveVulnerabilitiesPerWeek::truncate();

        $this->updateActiveVulnerabilitiesPerWeek();

        $this->info(
            "Active vulnerabilities count per week updated"
        );
    }

    /**
     * Updates the count of active vulnerabilities per week.
     *
     * @return void
     */
    public function updateActiveVulnerabilitiesPerWeek()
    {
        $start = now()->subWeeks(9)->startOfWeek();

        foreach (CarbonPeriod::create($start, '1 week', Carbon::today()) as $date) {
            $lastDay = $date->endOfWeek()->format('Y-m-d');
            $firstDay = $date->startOfWeek()->format('Y-m-d');

            $totalOpenVulnerability = $this->repository->getActiveVulnerabilitiesCountByWeek($firstDay,$lastDay);

            ActiveVulnerabilitiesPerWeek::insert([
                'start_date' => $firstDay,
                'end_date' => $lastDay,
                'vulnerabilities_count' => $totalOpenVulnerability]
            );
        }
    }

}
