<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\User;
use App\Models\ActiveAdminUsersLog;
use App\Models\UserType;

class ActiveAdminLog extends Command
{

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'ActiveAdminLog:activeadminlog';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Log active admin users';


    /**
     * Execute the console command.
     *
     * @return void
     */
    public function handle()
    {
        $userCount = [];

        $userTypes = UserType::where('is_admin', 1)->where('name', '!=', 'Super Admin')->get();

        foreach ($userTypes as $userType) {
            $count = User::where('user_type_id', $userType->id)->active()->count();
            $userCount[] = [
                'userType' => $userType->name,
                'count'    => $count
            ];
        }

        $logData = [
            'no_of_users' => json_encode($userCount)
        ];

        ActiveAdminUsersLog::create($logData);
    }
}
